### 财税上线 sql

##### 操作库： ent_deliver

```sql
CREATE TABLE `fi_settlebill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '' COMMENT '结算单编码',
  `created_at` datetime NOT NULL COMMENT '创建时间',
  `updated_at` datetime NOT NULL COMMENT '更新时间',
  `version` int(11) NOT NULL DEFAULT '0',
  `settle_amount` double DEFAULT '0' COMMENT '结算金额',
  `auditedStatus` tinyint(1) DEFAULT '0' COMMENT '结算状态',
  `isPayedStatus` tinyint(1) DEFAULT '0' COMMENT '支付状态',
  `creator_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `creator` varchar(255) DEFAULT NULL COMMENT '创建人',
  `deleted_at` datetime DEFAULT NULL COMMENT '删除时间',
  `memo` varchar(512) DEFAULT NULL COMMENT '备注',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人id',
  `auditor` varchar(255) DEFAULT NULL COMMENT '审核人',
  `payer_id` int(11) DEFAULT NULL COMMENT '付款人id',
  `payer` varchar(255) DEFAULT NULL COMMENT '付款人',
  `facilitator_id` int(11) DEFAULT NULL COMMENT '服务商id',
  `facilitator_name` varchar(255) DEFAULT NULL COMMENT '服务商',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COMMENT='公司主体表';

CREATE TABLE `fi_tax_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '财税-企业信息表',
  `demand_code` varchar(255) DEFAULT NULL COMMENT '需求编号',
  `company_name` varchar(255) DEFAULT NULL COMMENT '企业名称',
  `legal_person` varchar(255) DEFAULT NULL COMMENT '法人姓名',
  `tax_number` varchar(255) DEFAULT NULL COMMENT '税号',
  `taxpayer_type` varchar(255) DEFAULT NULL COMMENT '纳税人类型',
  `engaged_industry` varchar(255) DEFAULT NULL COMMENT '所属行业',
  `region` varchar(255) DEFAULT NULL COMMENT '地区',
  `address` varchar(255) DEFAULT NULL COMMENT '企业地址',
  `created_at` datetime NOT NULL COMMENT '创建时间',
  `updated_at` datetime NOT NULL COMMENT '更新时间，也是当前商机状态的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `demand_code_UNIQUE` (`demand_code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `fi_tax_operation_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '财税-操作记录表',
  `demand_code` varchar(255) DEFAULT NULL COMMENT '需求编号',
  `operator` json DEFAULT NULL COMMENT '操作人',
  `operation_type` varchar(255) DEFAULT NULL COMMENT '操作类型',
  `operation_details` json DEFAULT NULL COMMENT '操作详细记录',
  `order_type` varchar(255) DEFAULT NULL COMMENT '区分操作需求还是交付单',
  `created_at` datetime NOT NULL COMMENT '创建时间',
  `updated_at` datetime NOT NULL COMMENT '更新时间，也是当前商机状态的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `fi_tax_push_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `delivery_code` varchar(255) DEFAULT NULL COMMENT '交付单id（服务实例的id）',
  `current_period` varchar(255) DEFAULT NULL COMMENT '当前账期',
  `data_type` varchar(255) DEFAULT NULL COMMENT '数据类型：1：账套信息 2：报表信息 3：报税信息 4：邮寄信息',
  `req_data` json DEFAULT NULL COMMENT '推送请求数据',
  `res_data` json DEFAULT NULL COMMENT '推送返回数据',
  `push_status` varchar(255) DEFAULT NULL COMMENT '推送状态',
  `rys_check` varchar(255) DEFAULT NULL COMMENT '融易算是否确认，1：确认 0 未确认',
  `check_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '融易算确认的时间',
  `created_at` datetime NOT NULL COMMENT '创建时间',
  `updated_at` datetime NOT NULL COMMENT '更新时间',
  `version` int(11) NOT NULL COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COMMENT='财税项目推送日志记录表';

CREATE TABLE `fi_tax_scheme` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '财税-方案表',
  `demand_code` varchar(255) DEFAULT NULL COMMENT '需求编号',
  `solution_bizid` varchar(255) DEFAULT NULL COMMENT '方案编号',
  `service_type` varchar(255) DEFAULT NULL COMMENT '服务类型',
  `company_type` varchar(255) DEFAULT NULL COMMENT '公司类型',
  `taxpayer_type` varchar(255) DEFAULT NULL COMMENT '纳税人类型',
  `service_name` varchar(255) DEFAULT NULL COMMENT '服务地区',
  `service_code` varchar(255) DEFAULT NULL COMMENT '服务地区编码',
  `buy_duration` varchar(255) DEFAULT NULL COMMENT '购买时长',
  `number` varchar(255) DEFAULT NULL COMMENT '数量',
  `total_cost` varchar(255) DEFAULT NULL COMMENT '总计费用',
  `remarks` varchar(255) DEFAULT NULL COMMENT '备注',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `demand_code_UNIQUE` (`demand_code`) USING BTREE,
  KEY `solution_bizid_UNIQUE` (`solution_bizid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `salesman_his` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '业务员历史表',
  `flow_type` varchar(255) NOT NULL COMMENT '流程类型（商机、方案、交付单）',
  `flow_id` varchar(255) NOT NULL COMMENT '流程对应id（各种表里对应的id）',
  `flow_code` varchar(255) NOT NULL COMMENT '类型的编号',
  `salesman_info` json NOT NULL COMMENT '业务员信息',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COMMENT='业务员历史表';

ALTER TABLE `delivery_bill` add `biz_id` varchar(255) DEFAULT NULL COMMENT '融易算-服务实例id';

ALTER TABLE `bussiness_opportunity` add `biz_id` varchar(255) DEFAULT NULL COMMENT '融易算-服务实例id';

ALTER TABLE `delivery_bill`  ADD COLUMN company_name  VARCHAR (255) GENERATED ALWAYS  AS (`delivery_info` ->> '$.companyName' ) VIRTUAL;
CREATE INDEX company_name_virtual_index  ON delivery_bill(company_name);

ALTER TABLE `delivery_bill`  ADD COLUMN  `v_setup_status` varchar(255) GENERATED ALWAYS AS (`delivery_info` ->> '$.setupStatus') VIRTUAL;
CREATE INDEX v_setup_status_virtual_index  ON delivery_bill(v_setup_status);

ALTER TABLE `delivery_bill`  ADD COLUMN  `v_creditCode` varchar(255) GENERATED ALWAYS AS (`delivery_info` ->> '$.creditCode') VIRTUAL;
CREATE INDEX v_creditCode_virtual_index  ON delivery_bill(v_creditCode);

ALTER TABLE `delivery_bill`  ADD COLUMN   `v_ftClientId` varchar(255) GENERATED ALWAYS AS (`delivery_info` ->> '$.ftClientId') VIRTUAL;
CREATE INDEX v_ftClientId_virtual_index  ON delivery_bill(v_ftClientId);
```

